/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.tileentity;

import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.init.ModBlockEntities;
import dev.toma.gunsrpg.common.init.ModRecipeTypes;
import dev.toma.gunsrpg.common.tileentity.VanillaInventoryTileEntity;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchOutputCount;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchOutputCountType;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchOutputModifier;
import dev.toma.gunsrpg.resource.ammobench.AmmoBenchRecipe;
import dev.toma.gunsrpg.util.ModUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.IPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class AmmoBenchTileEntity
extends VanillaInventoryTileEntity
implements ITickableTileEntity {
    public static final int[] SLOT_OUTPUTS = new int[]{6, 7, 8, 9, 10, 11};
    public static final int[] SLOT_INPUTS = new int[]{0, 1, 2, 3, 4, 5};
    private boolean crafting;
    private int recipeCraftTime;
    private int timeCrafting;
    private List<AmmoBenchRecipe> recipeSelection = new ArrayList<AmmoBenchRecipe>();
    private int selectedRecipeIndex;
    private CraftingRecipeImage image;

    public AmmoBenchTileEntity() {
        super((TileEntityType<? extends VanillaInventoryTileEntity>)((TileEntityType)ModBlockEntities.AMMO_BENCH.get()));
    }

    public void func_73660_a() {
        if (this.crafting) {
            AmmoBenchRecipe recipe = this.getActiveRecipe();
            if (this.image == null || recipe == null || !recipe.matches(this, this.field_145850_b)) {
                this.interruptCrafting();
                return;
            }
            if (--this.timeCrafting <= 0) {
                ItemStack[] results = this.image.assembleItems();
                if (!ModUtils.canFitItems(results, this, SLOT_OUTPUTS)) {
                    this.setRecipeIndex(0);
                } else if (!this.field_145850_b.field_72995_K) {
                    ModUtils.insertItems(results, this, SLOT_OUTPUTS);
                    recipe.getInputs().forEach(input -> input.consume(this, SLOT_INPUTS));
                    this.onSlotChanged();
                    if (this.crafting) {
                        this.timeCrafting = this.recipeCraftTime;
                    }
                }
            }
        }
    }

    public boolean isCrafting() {
        return this.crafting;
    }

    public void startCrafting(ServerPlayerEntity player) {
        AmmoBenchRecipe recipe = this.getActiveRecipe();
        if (recipe == null) {
            return;
        }
        PlayerData.get((PlayerEntity)player).ifPresent(data -> {
            this.image = this.getImage(data.getSkillProvider());
            ItemStack[] results = this.image.assembleItems();
            if (!ModUtils.canFitItems(results, this, SLOT_OUTPUTS) || !recipe.canPlayerCraft((PlayerEntity)player)) {
                return;
            }
            this.crafting = true;
            this.timeCrafting = recipe.getCraftingTimer();
            this.recipeCraftTime = recipe.getCraftingTimer();
        });
        player.field_71133_b.func_184103_al().func_148540_a((IPacket)this.func_189518_D_());
        this.func_70296_d();
    }

    public void interruptCrafting() {
        this.setRecipeIndex(0);
    }

    @Override
    public IItemHandlerModifiable createInventory() {
        return new ItemStackHandler(12);
    }

    @Override
    public void write(CompoundNBT nbt) {
        nbt.func_74757_a("crafting", this.crafting);
        nbt.func_74768_a("time", this.timeCrafting);
        nbt.func_74768_a("totalCraftTime", this.recipeCraftTime);
        nbt.func_74768_a("selectedRecipeIndex", this.selectedRecipeIndex);
        if (this.image != null) {
            nbt.func_218657_a("craftingImage", (INBT)this.image.serialize());
        }
        ListNBT selection = new ListNBT();
        this.recipeSelection.forEach(recipe -> selection.add((Object)StringNBT.func_229705_a_((String)recipe.func_199560_c().toString())));
        nbt.func_218657_a("selection", (INBT)selection);
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.crafting = nbt.func_74767_n("crafting");
        this.timeCrafting = nbt.func_74762_e("time");
        this.recipeCraftTime = nbt.func_74762_e("totalCraftTime");
        this.selectedRecipeIndex = nbt.func_74762_e("selectedRecipeIndex");
        this.image = null;
        if (nbt.func_74764_b("craftingImage")) {
            this.image = CraftingRecipeImage.deserialize(nbt.func_150295_c("craftingImage", 10));
        }
        ListNBT selection = nbt.func_150295_c("selection", 8);
        this.recipeSelection.clear();
        if (this.field_145850_b != null) {
            RecipeManager manager = this.field_145850_b.func_199532_z();
            Map recipeMap = manager.func_241447_a_(ModRecipeTypes.AMMO_BENCH_RECIPE_TYPE).stream().collect(Collectors.toMap(AmmoBenchRecipe::func_199560_c, Function.identity()));
            selection.forEach(inbt -> {
                ResourceLocation recipeId = new ResourceLocation(inbt.func_150285_a_());
                AmmoBenchRecipe recipe = (AmmoBenchRecipe)recipeMap.get(recipeId);
                if (recipe != null) {
                    this.recipeSelection.add(recipe);
                }
            });
        }
    }

    public AmmoBenchRecipe getActiveRecipe() {
        if (this.recipeSelection.isEmpty() || this.selectedRecipeIndex >= this.recipeSelection.size()) {
            return null;
        }
        return this.recipeSelection.get(this.selectedRecipeIndex);
    }

    public boolean canCraftCurrentRecipe(PlayerEntity player) {
        AmmoBenchRecipe recipe = this.getActiveRecipe();
        if (recipe != null) {
            return recipe.matches(this, this.field_145850_b) && recipe.canPlayerCraft(player);
        }
        return false;
    }

    public boolean canSelectNextRecipe() {
        return !this.recipeSelection.isEmpty() && this.selectedRecipeIndex + 1 < this.recipeSelection.size();
    }

    public boolean canSelectPreviousRecipe() {
        return !this.recipeSelection.isEmpty() && this.selectedRecipeIndex > 0;
    }

    public void onSlotChanged() {
        AmmoBenchRecipe currentRecipe;
        if (this.field_145850_b == null) {
            return;
        }
        RecipeManager manager = this.field_145850_b.func_199532_z();
        List recipeList = manager.func_241447_a_(ModRecipeTypes.AMMO_BENCH_RECIPE_TYPE);
        AmmoBenchRecipe oldRecipe = this.getActiveRecipe();
        this.recipeSelection = recipeList.stream().filter(recipe -> recipe.matches(this, this.field_145850_b)).collect(Collectors.toList());
        if (this.selectedRecipeIndex >= this.recipeSelection.size()) {
            this.setRecipeIndex(0);
        }
        if (oldRecipe != (currentRecipe = this.getActiveRecipe())) {
            this.setRecipeIndex(0);
        }
        this.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_73046_m().func_184103_al().func_148540_a((IPacket)this.func_189518_D_());
        }
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex;
    }

    public void setRecipeIndex(int index) {
        this.selectedRecipeIndex = index;
        this.recipeCraftTime = 0;
        this.crafting = false;
        AmmoBenchRecipe recipe = this.getActiveRecipe();
        if (recipe != null) {
            this.recipeCraftTime = recipe.getCraftingTimer();
        }
        this.func_70296_d();
    }

    public float getCraftingProgress() {
        return this.crafting ? 1.0f - (float)this.timeCrafting / (float)this.recipeCraftTime : 0.0f;
    }

    private CraftingRecipeImage getImage(ISkillProvider provider) {
        AmmoBenchRecipe recipe = this.getActiveRecipe();
        SingleItemImage[] outputImages = new SingleItemImage[recipe.getOutputs().size()];
        for (int i = 0; i < outputImages.length; ++i) {
            AmmoBenchRecipe.AmmoBenchOutput output = recipe.getOutputs().get(i);
            ItemStack stack = output.getItemStack();
            AmmoBenchOutputCount[] modifiers = (AmmoBenchOutputCount[])output.getOutputModifiers().stream().filter(modifier -> modifier.canApply(provider)).map(AmmoBenchOutputModifier::getCountFunction).toArray(AmmoBenchOutputCount[]::new);
            outputImages[i] = new SingleItemImage(stack, modifiers);
        }
        return new CraftingRecipeImage(outputImages);
    }

    private static final class SingleItemImage {
        private final ItemStack stack;
        private final AmmoBenchOutputCount[] modifiers;

        SingleItemImage(ItemStack stack, AmmoBenchOutputCount[] modifiers) {
            this.stack = stack;
            this.modifiers = modifiers;
        }

        private ItemStack toItemStack() {
            ItemStack itemStack = this.stack.func_77946_l();
            for (AmmoBenchOutputCount modifier : this.modifiers) {
                int count = modifier.getCount(itemStack.func_190916_E());
                itemStack.func_190920_e(Math.min(itemStack.func_77976_d(), count));
            }
            return itemStack;
        }

        private CompoundNBT serialize() {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_218657_a("itemStack", (INBT)this.stack.serializeNBT());
            ListNBT list = new ListNBT();
            for (AmmoBenchOutputCount count : this.modifiers) {
                list.add((Object)AmmoBenchOutputCountType.toNbt(count));
            }
            nbt.func_218657_a("modifiers", (INBT)list);
            return nbt;
        }

        private static SingleItemImage deserialize(CompoundNBT nbt) {
            ItemStack itemStack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("itemStack"));
            ListNBT modifiers = nbt.func_150295_c("modifiers", 10);
            AmmoBenchOutputCount[] counts = new AmmoBenchOutputCount[modifiers.size()];
            for (int i = 0; i < modifiers.size(); ++i) {
                counts[i] = AmmoBenchOutputCountType.fromNbt(modifiers.func_150305_b(i));
            }
            return new SingleItemImage(itemStack, counts);
        }
    }

    private static final class CraftingRecipeImage {
        private final SingleItemImage[] images;

        private CraftingRecipeImage(SingleItemImage[] images) {
            this.images = images;
        }

        private ItemStack[] assembleItems() {
            return (ItemStack[])Arrays.stream(this.images).map(rec$ -> ((SingleItemImage)rec$).toItemStack()).toArray(ItemStack[]::new);
        }

        private ListNBT serialize() {
            ListNBT listNBT = new ListNBT();
            for (SingleItemImage image : this.images) {
                listNBT.add((Object)image.serialize());
            }
            return listNBT;
        }

        private static CraftingRecipeImage deserialize(ListNBT nbt) {
            SingleItemImage[] images = new SingleItemImage[nbt.size()];
            for (int i = 0; i < nbt.size(); ++i) {
                images[i] = SingleItemImage.deserialize(nbt.func_150305_b(i));
            }
            return new CraftingRecipeImage(images);
        }
    }
}

